/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageLoadListener;
import com.sun.javafx.iio.ImageLoader;
import com.sun.javafx.iio.ImageMetadata;
import java.util.HashSet;

public abstract class ImageLoaderImpl
implements ImageLoader {
    protected ImageFormatDescription formatDescription;
    protected HashSet<ImageLoadListener> listeners;
    protected int lastPercentDone = -1;

    protected ImageLoaderImpl(ImageFormatDescription formatDescription) {
        if (formatDescription == null) {
            throw new IllegalArgumentException("formatDescription == null!");
        }
        this.formatDescription = formatDescription;
    }

    @Override
    public final ImageFormatDescription getFormatDescription() {
        return this.formatDescription;
    }

    @Override
    public final void addListener(ImageLoadListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet();
        }
        this.listeners.add(listener);
    }

    @Override
    public final void removeListener(ImageLoadListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void emitWarning(String warning) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ImageLoadListener l : this.listeners) {
                l.imageLoadWarning(this, warning);
            }
        }
    }

    protected void updateImageProgress(float percentageDone) {
        int percentDone;
        int delta;
        if (this.listeners != null && !this.listeners.isEmpty() && (delta = 5) * (percentDone = (int)percentageDone) / delta % delta == 0 && percentDone != this.lastPercentDone) {
            this.lastPercentDone = percentDone;
            for (ImageLoadListener listener : this.listeners) {
                listener.imageLoadProgress(this, percentDone);
            }
        }
    }

    protected void updateImageMetadata(ImageMetadata metadata) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ImageLoadListener l : this.listeners) {
                l.imageLoadMetaData(this, metadata);
            }
        }
    }
}

