/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.AbstractSurface;
import com.sun.pisces.GradientColorMap;
import com.sun.pisces.Transform6;

public final class PiscesRenderer {
    public static final int ARC_OPEN = 0;
    public static final int ARC_CHORD = 1;
    public static final int ARC_PIE = 2;
    private long nativePtr = 0L;
    private AbstractSurface surface;

    public PiscesRenderer(AbstractSurface surface) {
        this.surface = surface;
        this.initialize();
    }

    private native void initialize();

    public void setColor(int red, int green, int blue, int alpha) {
        this.checkColorRange(red, "RED");
        this.checkColorRange(green, "GREEN");
        this.checkColorRange(blue, "BLUE");
        this.checkColorRange(alpha, "ALPHA");
        this.setColorImpl(red, green, blue, alpha);
    }

    private native void setColorImpl(int var1, int var2, int var3, int var4);

    private void checkColorRange(int v, String componentName) {
        if (v < 0 || v > 255) {
            throw new IllegalArgumentException(componentName + " color component is out of range");
        }
    }

    public void setColor(int red, int green, int blue) {
        this.setColor(red, green, blue, 255);
    }

    public void setCompositeRule(int compositeRule) {
        if (compositeRule != 0 && compositeRule != 1 && compositeRule != 2) {
            throw new IllegalArgumentException("Invalid value for Composite-Rule");
        }
        this.setCompositeRuleImpl(compositeRule);
    }

    private native void setCompositeRuleImpl(int var1);

    private native void setLinearGradientImpl(int var1, int var2, int var3, int var4, int[] var5, int var6, Transform6 var7);

    public void setLinearGradient(int x0, int y0, int x1, int y1, int[] fractions, int[] rgba, int cycleMethod, Transform6 gradientTransform) {
        GradientColorMap gradientColorMap = new GradientColorMap(fractions, rgba, cycleMethod);
        this.setLinearGradientImpl(x0, y0, x1, y1, gradientColorMap.colors, cycleMethod, gradientTransform == null ? new Transform6(65536, 0, 0, 65536, 0, 0) : gradientTransform);
    }

    public void setLinearGradient(int x0, int y0, int x1, int y1, GradientColorMap gradientColorMap, Transform6 gradientTransform) {
        this.setLinearGradientImpl(x0, y0, x1, y1, gradientColorMap.colors, gradientColorMap.cycleMethod, gradientTransform == null ? new Transform6(65536, 0, 0, 65536, 0, 0) : gradientTransform);
    }

    public void setLinearGradient(int x0, int y0, int color0, int x1, int y1, int color1, int cycleMethod) {
        int[] fractions = new int[]{0, 65536};
        int[] rgba = new int[]{color0, color1};
        Transform6 ident = new Transform6(65536, 0, 0, 65536, 0, 0);
        this.setLinearGradient(x0, y0, x1, y1, fractions, rgba, cycleMethod, ident);
    }

    private native void setRadialGradientImpl(int var1, int var2, int var3, int var4, int var5, int[] var6, int var7, Transform6 var8);

    public void setRadialGradient(int cx, int cy, int fx, int fy, int radius, int[] fractions, int[] rgba, int cycleMethod, Transform6 gradientTransform) {
        GradientColorMap gradientColorMap = new GradientColorMap(fractions, rgba, cycleMethod);
        this.setRadialGradientImpl(cx, cy, fx, fy, radius, gradientColorMap.colors, cycleMethod, gradientTransform == null ? new Transform6(65536, 0, 0, 65536, 0, 0) : gradientTransform);
    }

    public void setRadialGradient(int cx, int cy, int fx, int fy, int radius, GradientColorMap gradientColorMap, Transform6 gradientTransform) {
        this.setRadialGradientImpl(cx, cy, fx, fy, radius, gradientColorMap.colors, gradientColorMap.cycleMethod, gradientTransform == null ? new Transform6(65536, 0, 0, 65536, 0, 0) : gradientTransform);
    }

    public void setTexture(int imageType, int[] data, int width, int height, int stride, Transform6 textureTransform, boolean repeat, boolean linearFiltering, boolean hasAlpha) {
        this.inputImageCheck(width, height, 0, stride, data.length);
        this.setTextureImpl(imageType, data, width, height, stride, textureTransform, repeat, linearFiltering, hasAlpha);
    }

    private native void setTextureImpl(int var1, int[] var2, int var3, int var4, int var5, Transform6 var6, boolean var7, boolean var8, boolean var9);

    public void setClip(int minX, int minY, int width, int height) {
        int x1 = Math.max(minX, 0);
        int y1 = Math.max(minY, 0);
        int x2 = Math.min(minX + width, this.surface.getWidth());
        int y2 = Math.min(minY + height, this.surface.getHeight());
        this.setClipImpl(x1, y1, x2 - x1, y2 - y1);
    }

    private native void setClipImpl(int var1, int var2, int var3, int var4);

    public void resetClip() {
        this.setClipImpl(0, 0, this.surface.getWidth(), this.surface.getHeight());
    }

    public void clearRect(int x, int y, int w, int h) {
        int x1 = Math.max(x, 0);
        int y1 = Math.max(y, 0);
        int x2 = Math.min(x + w, this.surface.getWidth());
        int y2 = Math.min(y + h, this.surface.getHeight());
        this.clearRectImpl(x1, y1, x2 - x1, y2 - y1);
    }

    private native void clearRectImpl(int var1, int var2, int var3, int var4);

    public void fillRect(int x, int y, int w, int h) {
        int x1 = Math.max(x, 0);
        int y1 = Math.max(y, 0);
        int x2 = Math.min(x + w, this.surface.getWidth() << 16);
        int y2 = Math.min(y + h, this.surface.getHeight() << 16);
        int w2 = x2 - x1;
        int h2 = y2 - y1;
        if (w2 > 0 && h2 > 0) {
            this.fillRectImpl(x1, y1, w2, h2);
        }
    }

    private native void fillRectImpl(int var1, int var2, int var3, int var4);

    public void emitAndClearAlphaRow(byte[] alphaMap, int[] alphaDeltas, int pix_y, int pix_x_from, int pix_x_to, int rowNum) {
        if (pix_x_to - pix_x_from > alphaDeltas.length) {
            throw new IllegalArgumentException("rendering range exceeds length of data");
        }
        this.emitAndClearAlphaRowImpl(alphaMap, alphaDeltas, pix_y, pix_x_from, pix_x_to, rowNum);
    }

    private native void emitAndClearAlphaRowImpl(byte[] var1, int[] var2, int var3, int var4, int var5, int var6);

    public void fillAlphaMask(byte[] mask, int x, int y, int width, int height, int offset, int stride) {
        if (mask == null) {
            throw new NullPointerException("Mask is NULL");
        }
        this.inputImageCheck(width, height, offset, stride, mask.length);
        this.fillAlphaMaskImpl(mask, x, y, width, height, offset, stride);
    }

    private native void fillAlphaMaskImpl(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void setLCDGammaCorrection(float gamma) {
        if (gamma <= 0.0f) {
            throw new IllegalArgumentException("Gamma must be greater than zero");
        }
        this.setLCDGammaCorrectionImpl(gamma);
    }

    private native void setLCDGammaCorrectionImpl(float var1);

    public void fillLCDAlphaMask(byte[] mask, int x, int y, int width, int height, int offset, int stride) {
        if (mask == null) {
            throw new NullPointerException("Mask is NULL");
        }
        this.inputImageCheck(width, height, offset, stride, mask.length);
        this.fillLCDAlphaMaskImpl(mask, x, y, width, height, offset, stride);
    }

    private native void fillLCDAlphaMaskImpl(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void drawImage(int imageType, int imageMode, int[] data, int width, int height, int offset, int stride, Transform6 textureTransform, boolean repeat, boolean linearFiltering, int bboxX, int bboxY, int bboxW, int bboxH, int lEdge, int rEdge, int tEdge, int bEdge, int txMin, int tyMin, int txMax, int tyMax, boolean hasAlpha) {
        this.inputImageCheck(width, height, offset, stride, data.length);
        this.drawImageImpl(imageType, imageMode, data, width, height, offset, stride, textureTransform, repeat, linearFiltering, bboxX, bboxY, bboxW, bboxH, lEdge, rEdge, tEdge, bEdge, txMin, tyMin, txMax, tyMax, hasAlpha);
    }

    private native void drawImageImpl(int var1, int var2, int[] var3, int var4, int var5, int var6, int var7, Transform6 var8, boolean var9, boolean var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19, int var20, int var21, int var22, boolean var23);

    private void inputImageCheck(int width, int height, int offset, int stride, int data_length) {
        if (width < 0) {
            throw new IllegalArgumentException("WIDTH must be positive");
        }
        if (height < 0) {
            throw new IllegalArgumentException("HEIGHT must be positive");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("OFFSET must be positive");
        }
        if (stride < 0) {
            throw new IllegalArgumentException("STRIDE must be positive");
        }
        if (stride < width) {
            throw new IllegalArgumentException("STRIDE must be >= WIDTH");
        }
        int nbits = 32 - Integer.numberOfLeadingZeros(stride) + 32 - Integer.numberOfLeadingZeros(height);
        if (nbits > 31) {
            throw new IllegalArgumentException("STRIDE * HEIGHT is too large");
        }
        if (offset + stride * (height - 1) + width > data_length) {
            throw new IllegalArgumentException("STRIDE * HEIGHT exceeds length of data");
        }
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    private native void nativeFinalize();
}

