/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.media.jfxmedia.MediaError;
import java.net.UnknownHostException;

public final class MediaException
extends RuntimeException {
    private final Type type;

    static Type errorCodeToType(int errorCode) {
        Type errorType = errorCode == MediaError.ERROR_LOCATOR_CONNECTION_LOST.code() ? Type.MEDIA_INACCESSIBLE : (errorCode == MediaError.ERROR_GSTREAMER_SOURCEFILE_NONEXISTENT.code() || errorCode == MediaError.ERROR_GSTREAMER_SOURCEFILE_NONREGULAR.code() ? Type.MEDIA_UNAVAILABLE : (errorCode == MediaError.ERROR_MEDIA_AUDIO_FORMAT_UNSUPPORTED.code() || errorCode == MediaError.ERROR_MEDIA_UNKNOWN_PIXEL_FORMAT.code() || errorCode == MediaError.ERROR_MEDIA_VIDEO_FORMAT_UNSUPPORTED.code() || errorCode == MediaError.ERROR_LOCATOR_CONTENT_TYPE_NULL.code() || errorCode == MediaError.ERROR_LOCATOR_UNSUPPORTED_MEDIA_FORMAT.code() || errorCode == MediaError.ERROR_LOCATOR_UNSUPPORTED_TYPE.code() || errorCode == MediaError.ERROR_GSTREAMER_UNSUPPORTED_PROTOCOL.code() || errorCode == MediaError.ERROR_MEDIA_MP3_FORMAT_UNSUPPORTED.code() || errorCode == MediaError.ERROR_MEDIA_AAC_FORMAT_UNSUPPORTED.code() || errorCode == MediaError.ERROR_MEDIA_H264_FORMAT_UNSUPPORTED.code() || errorCode == MediaError.ERROR_MEDIA_HLS_FORMAT_UNSUPPORTED.code() ? Type.MEDIA_UNSUPPORTED : (errorCode == MediaError.ERROR_MEDIA_CORRUPTED.code() ? Type.MEDIA_CORRUPTED : ((errorCode & MediaError.ERROR_BASE_GSTREAMER.code()) == MediaError.ERROR_BASE_GSTREAMER.code() || (errorCode & MediaError.ERROR_BASE_JNI.code()) == MediaError.ERROR_BASE_JNI.code() ? Type.PLAYBACK_ERROR : Type.UNKNOWN))));
        return errorType;
    }

    static MediaException exceptionToMediaException(Exception e) {
        com.sun.media.jfxmedia.MediaException me;
        MediaError error;
        Type errType = Type.UNKNOWN;
        if (e.getCause() instanceof UnknownHostException) {
            errType = Type.MEDIA_UNAVAILABLE;
        } else if (e.getCause() instanceof IllegalArgumentException) {
            errType = Type.MEDIA_UNSUPPORTED;
        } else if (e instanceof com.sun.media.jfxmedia.MediaException && (error = (me = (com.sun.media.jfxmedia.MediaException)e).getMediaError()) != null) {
            errType = MediaException.errorCodeToType(error.code());
        }
        return new MediaException(errType, (Throwable)e);
    }

    static MediaException haltException(String message) {
        return new MediaException(Type.PLAYBACK_HALTED, message);
    }

    static MediaException getMediaException(Object source, int errorCode, String message) {
        String errorDescription = MediaError.getFromCode(errorCode).description();
        String exceptionMessage = "[" + source + "] " + message + ": " + errorDescription;
        Type errorType = MediaException.errorCodeToType(errorCode);
        return new MediaException(errorType, exceptionMessage);
    }

    MediaException(Type type, Throwable t) {
        super(t);
        this.type = type;
    }

    MediaException(Type type, String message, Throwable t) {
        super(message, t);
        this.type = type;
    }

    MediaException(Type type, String message) {
        super(message);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        String errString = "MediaException: " + (Object)((Object)this.type);
        if (this.getMessage() != null) {
            errString = errString + " : " + this.getMessage();
        }
        if (this.getCause() != null) {
            errString = errString + " : " + this.getCause();
        }
        return errString;
    }

    public static enum Type {
        MEDIA_CORRUPTED,
        MEDIA_INACCESSIBLE,
        MEDIA_UNAVAILABLE,
        MEDIA_UNSPECIFIED,
        MEDIA_UNSUPPORTED,
        OPERATION_UNSUPPORTED,
        PLAYBACK_ERROR,
        PLAYBACK_HALTED,
        UNKNOWN;

    }
}

